<!-- Main Content -->
<?= helper('form'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('services', "Services") ?></h1>
            <div class="section-header-breadcrumb">

                <div class="breadcrumb-item active"><a href="<?= base_url('/partner/dashboard') ?>"> <i class="fas fa-home-alt text-danger"></i><?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item active"><a href="<?= base_url('/partner/services/add') ?>"><?= labels('add_services', 'Add Services') ?></a></div>
            </div>
        </div>
        <div class="container-fluid card">
            <div class="row">
                <div class="col-md">
                    <h2 class='section-title'><?= labels('list_of_services', "List of Services") ?></h2>
                </div>
                <div class="col-md text-right m-auto">
                    <a class="btn btn-primary text-white" id="add_promo" href="<?= base_url('partner/services/add'); ?>"><i class="fas fa-plus"></i> <?= labels('add_services', 'Add Services') ?></a>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <table class="table table-bordered table-hover" data-detail-formatter="detailFormatter" id="user_list" data-auto-refresh="true" data-show-columns="true" data-show-refresh="true" data-toggle="table" data-search-highlight="true" data-server-sort="true" data-page-list="[5, 10, 25, 50, 100, 200, All]" data-url="<?= base_url("partner/services/list") ?>" data-side-pagination="server" data-pagination="true" data-search="true" data-sort-name="id" data-sort-order="desc">
                        <thead>
                            <tr>
                                <!-- invisible data -->
                                <th data-field="id" class="text-center" data-visible="false" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="category_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('category_id', 'Category ID') ?></th>
                                <th data-field="category_name" class="text-center" data-visible="false" data-sortable="true"><?= labels('category_name', 'Category Name') ?></th>
                                <th data-field="parent_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('parent_id', 'Parent ID') ?></th>
                                <th data-field="user_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('user_id', 'User ID') ?></th>
                                <!-- invisible data -->

                                <!-- EVERY VISIBLE DATA HERE -->
                                <th data-field="title" class="text-center" data-sortable="true"><?= labels('title', 'Title') ?></th>
                                <th data-field="slug" class="text-center" data-visible="false" data-sortable="true"><?= labels('slug', 'Slug') ?></th>
                                <th data-field="tags" class="text-center" data-visible="false" data-sortable="true"><?= labels('tags', 'Tags') ?></th>
                                <th data-field="image_of_the_service" class="text-center" data-sortable="true"><?= labels('image', 'Image') ?></th>
                                <th data-field="price" class="text-center" data-sortable="true"><?= labels('price', 'Price') ?></th>
                                <th data-field="discounted_price" class="text-center" data-sortable="true"><?= labels('discounted_price', 'Discounted Price') ?></th>
                                <th data-field="duration" class="text-center" data-sortable="true"><?= labels('duration', 'Duration') . '(min)' ?></th>
                                <!-- <th data-field="status" class="text-center" data-sortable="true"><?= labels('status', 'status') ?></th> -->
                                <th data-field="is_cancelable" class="text-center" data-sortable="true"><?= labels('is_cancelable_?', 'is service cancelable?') ?></th>
                                <th data-field="cancelable_till" class="text-center" data-sortable="true"><?= labels('cancelable_till', 'Cancelable before') . '(min)' ?></th>
                                <th data-field="tax_type" class="text-center" data-visible="false" data-sortable="true"><?= labels('tax_type', 'Tax Type') ?></th>
                                <th data-field="status_badge" class="text-center" data-sortable="true"><?= labels('status ', 'Status') ?></th>
                                <th data-field="operations" class="text-center" data-events="services_events"><?= labels('operations', 'Operations') ?></th>

                                <!-- EVERY VISIBLE DATA HERE -->

                                <!-- invisible data -->
                                <th data-field="description" class="text-center" data-visible="false" data-sortable="true"><?= labels('description', 'Description') ?></th>
                                <th data-field="number_of_members_required" class="text-center" data-visible="false" data-sortable="true"><?= labels('members_required_to_perform_task', 'Members required to perform Tasks') ?></th>
                                <th data-field="tax_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('tax_id', 'Tax ID') ?></th>

                                <th data-field="max_quantity_allowed" class="text-center" data-visible="false" data-sortable="true"><?= labels('max_quantity_allowed', 'Max Quantity allowed for services') ?></th>
                                <th data-field="is_pay_later_allowed" class="text-center" data-visible="false" data-sortable="true"><?= labels('pay_later_allowed', 'Pay Later Allowed') ?></th>
                                <th data-field="created_at" class="text-center" data-visible="false" data-sortable="true"><?= labels('created_at', 'Created At') ?></th>
                                <th data-field="updated_at" class="text-center" data-visible="false" data-sortable="true"><?= labels('updated_at', 'Updated At') ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>


<!-- model for update -->
<div class="modal fade" id="update_modal" tabindex="-1" role="dialog" aria-labelledby="update_modal_ser" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?= labels('update_service', 'Update Service') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <?= form_open('/partner/services/update_service', ['method' => "post", 'class' => 'form-submit-event', 'id' => 'update_service', 'enctype' => "multipart/form-data"]); ?>
                <input type="hidden" name="service_id" id="service_id">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title"><?= labels('title', 'Title') ?></label>
                            <input class="form-control" type="text" name="title">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="jquery-script-clear"></div>
                        <div class="categories" id="categories">
                            <label for="category_item"><?= labels('choose_a_category_for_your_service', 'Choose a Category for your service') ?></label>
                            <select id="category_item" class="form-control" name="categories">
                                <option value=""> <?= labels('select_category', 'Select Category') ?></option>
                                <?php foreach ($categories as $category) : ?>
                                    <option value="<?= $category['id'] ?>"><?= $category['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- <div class="col-md-6">
                        <div class="form-group">
                            <label for="sub_category"><?= labels('sub_category ', 'Sub Categories') ?></label>
                            <input type="text" class="form-control" name="sub_category" id="sub_category" placeholder="" value="">
                        </div>
                    </div> -->

                    <div class="col-md-6">
                        <div class="form-group mt-4">
                            <label for="tags"><?= labels('tags', 'Tags') ?></label>
                            <input id="service_tags" class="" type="text" name="tags[]">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="tax_type"><?= labels('tax_type', 'Tax Type') ?></label>
                            <select name="tax_type" id="tax_type" class="form-control">
                                <option value="excluded"><?= labels('tax_excluded_in_price', 'Tax Excluded In Price') ?></option>
                                <option value="included"><?= labels('tax_included_in_price', 'Tax Included In Price') ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="jquery-script-clear"></div>
                        <div class="" id="">

                            <label for="partner"><?= labels('select_tax', 'Select Tax') ?></label> <br>
                            <select id="edit_tax" name="edit_tax_id" class="form-control w-100">
                                <option value=""><?= labels('select_tax', 'Select Tax') ?></option>
                                <?php foreach ($tax_data as $pn) : ?>
                                    <option value="<?= $pn['id'] ?>"><?= $pn['title'] ?>(<?= $pn['percentage'] ?>%)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="custom-file">
                            <div class="form-group">
                                <?= labels('service_image', "Service Image") ?>
                                <input type="file" class="custom-file-input" id="image" name="image" accept='image/*' onchange="readURL(this)">
                                <input type="hidden" class="form-control" name="old_icon" id="old_icon">
                                <label class="custom-file-label mt-4" for="image"><?= labels('choose_file', 'Choose file') ?></label>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 mt-3">
                        <div class="form-group image">
                            <img src="<?= base_url('public/backend/assets/img/news/img01.jpg') ?>" alt="Service Image" width="30%" id="service_image">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="price"><?= labels('price', 'Price') ?></label>
                            <input id="price" class="form-control" type="text" name="price" placeholder="price">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="discounted_price"><?= labels('discounted_price', 'Discounted Price') ?></label>
                            <input id="discounted_price" class="form-control" type="text" name="discounted_price" placeholder="Discounted Price">
                        </div>
                    </div>
                </div>
                <div class="row">

                    <div class="col-lg-3">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="pay_later" name="pay_later">
                            <label class="custom-control-label" for="pay_later"><?= labels('pay_later_allowed', 'Pay Later Allowed') ?></label>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" class="custom-control-input" id="is_cancelable" name="is_cancelable">
                            <label class="custom-control-label" for="is_cancelable"><?= labels('is_cancelable_?', 'is service cancelable') ?>?</label>
                        </div>
                    </div>
                    <div class="col-lg-3 cancelable-till">
                        <div class="form-group">
                            <label for="cancelable_till"><?= labels('cancelable_till', 'Cancelable before') ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <span><?= labels('minutes', 'Minutes') ?></span>
                                    </div>
                                </div>
                                <input type="number" style="height: 42px;" class="form-control" name="cancelable_till" id="cancelable_till" placeholder="Ex. 30" min="0" value="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="members"><?= labels('members_required_to_perform_task', 'Members required to perform Tasks') ?></label>
                            <input id="members" class="form-control" type="text" name="members" placeholder="Members Required">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="duration"><?= labels('duration_to_perform_task', 'Duration to Perform Task') ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <span><?= labels('minutes', 'Minutes') ?></span>
                                    </div>
                                </div>
                                <input type="text" style="height: 42px;"  class="form-control" name="duration" id="duration" placeholder="Duration of the Service" value="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg">
                        <div class="form-group">
                            <label for="max_qty"><?= labels('max_quantity_allowed', 'Max Quantity allowed for services') ?></label>
                            <input id="max_qty" class="form-control" type="text" name="max_qty" placeholder="Max Quantity allowed for services">
                        </div>
                    </div>
                    <div class="col-lg">
                        <div class="form-group">
                            <label for="Description"><?= labels('description', 'Description') ?></label>
                            <textarea rows='2' cols='30' class='form-control h-50' name="description"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Status<span class="text-danger text-sm">*</span></label>
                            <br>
                            <div id="edit_status" class="btn-group col-sm-8" style="margin-left: -11px;">
                                <label class="btn btn-primary" data-toggle-class="btn-primary" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="edit_status" id="edit_status_active" value="1">Active </label>
                                <label class="btn btn-danger" data-toggle-class="btn-danger" data-toggle-passive-class="btn-default">
                                    <input type="radio" name="edit_status" id="edit_status_deactive" value="0" checked=""> Deactive </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-2">
                        <div class="form-group">
                            <input type="submit" value="<?= labels('update_service', 'Update Service') ?>" id="service_submit" class="btn btn-success btn-block">
                        </div>
                    </div>
                    <div class="col-2">
                        <div class="form-group">
                            <input type="reset" value="<?= labels('Reset', 'Reset') ?>" class="btn btn-danger btn-block">
                        </div>
                    </div>
                </div>
                <?= form_close() ?>
                <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button> -->
            </div>
        </div>
    </div>
</div>